﻿var activityHistory = {
    context: $(".v-activityHistory"),
    initialize: function () {
        var respondentId = $(".v-respondentId").val();

        $(".h-surveyHistoryTable", this.context).a4datatable({            
            title: resources.SurveyHistory,
            ajaxAction: a4.getSurveyAction("GetRespondentSurveyHistory", "Analyze"),
            ajaxParams: { "respondentId": respondentId },
            displaySearchBox: false,
            displayColumnSelector: false,
            columns: [
                { "Name": "DateTime", "Title": resources.DateTime, "Data": "DateTime" },
                { "Name": "Disposition", "Title": resources.Result, "Data": "DispositionEnum" },
                { "Name": "Duration", "Title": resources.Duration, "Data": "DurationTime" },
                { "Name": "Device", "Title": resources.Device, "Data": "Device" },
                { "Name": "Location", "Title": resources.Geolocation, "Data": "Location", "Sortable": false, "Visible": isOfflineSurvey && canReadPII },
                { "Name": "UserName", "Title": resources.User, "Data": "UserName", "Visible": canReadPII }],
        });

        $(".h-distributionHistoryTable", this.context).a4datatable({            
            title: resources.DistributionHistory,
            ajaxAction: a4.getSurveyAction("GetRespondentDistributionHistory", "Analyze"),
            ajaxParams: { "respondentId": respondentId },
            displaySearchBox: false,
            displayColumnSelector: false,
            columns: [
                { "Name": "DateTime", "Title": resources.DateTime, "Data": "DateTime" },
                { "Name": "DistributionName", "Title": resources.DistributionName, "Data": "DistributionName" },
                { "Name": "DistributionType", "Title": resources.DistributionType, "Data": "DistributionType" },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum" }]

        });
    }
}

$(document).ready(function () {
    if (activityHistory.context.length > 0) {
        activityHistory.initialize();
    }
});